CREATE OR REPLACE FUNCTION addColumn() RETURNS VOID AS $BODY$
BEGIN
    IF EXISTS (SELECT 1 FROM information_schema.columns
                    WHERE table_name= 'pdv_identifica_paf'
                         and column_name='nr_credenciamento_sefaz') THEN

        RAISE NOTICE 'Coluna "nr_credenciamento_sefaz" na tabela "pdv_identifica_paf" ja existe!' ;

    ELSE
		ALTER TABLE public.pdv_identifica_paf ADD nr_credenciamento_sefaz varchar(20) NULL;
        RAISE NOTICE 'Coluna "nr_credenciamento_sefaz" criada com sucesso!';
    END IF;

END;
-- fim bloco principal
$BODY$ LANGUAGE PLPGSQL VOLATILE COST 100;


ALTER FUNCTION addColumn() OWNER TO postgres;
SELECT addColumn();
DROP FUNCTION addColumn();